/* @(#) somx/entryed.c 2.3 1/20/94 10:25:06 [5/15/94 17:59:12] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#define entryED_Class_Source
#include <entryed.ih>

#include <somp.h>
#include "entryed.ih"
#include "direntry.ih"

/*
 *===========================================================================
 * Operation: ED Write
 * Write out a dirEntry object.
 *===========================================================================
 */

SOM_Scope void  SOMLINK sompEDWrite(entryED somSelf,  Environment *ev,
                                    SOMPMediaInterfaceAbstract thisMedia,
                                    SOMPPersistentObject thisObject)
{
    /* entryEDData *somThis = entryEDGetData(somSelf); */
    entryEDMethodDebug("entryED","sompEDWrite");

    /* Write name
       ------------------------------- */
    _sompWriteString(thisMedia, ev, __get_name(thisObject));
    if (ev->_major != NO_EXCEPTION) return;

    /* Write phone number string
       -------------------------------- */
    _sompWriteString(thisMedia, ev, __get_phone(thisObject));
    return;
}

/*
 *===========================================================================
 * Operation: ED Read
 * Read in a dirEntry object
 *===========================================================================
 */

SOM_Scope void  SOMLINK sompEDRead(entryED somSelf,  Environment *ev,
                                   SOMPMediaInterfaceAbstract thisMedia,
                                   SOMPPersistentObject thisObject)
{
    string rstring;

    /* entryEDData *somThis = entryEDGetData(somSelf); */
    entryEDMethodDebug("entryED","sompEDRead");

   /* Read name
      rstring is malloc'd by sompReadString
      ------------------------------------- */
    _sompReadString(thisMedia, ev, &rstring);
    if (ev->_major != NO_EXCEPTION) return;
    __set_name(thisObject, rstring);

   /* Read phone number
      ------------------------------------- */
    _sompReadString(thisMedia, ev, &rstring);
    if (ev->_major != NO_EXCEPTION) return;
    __set_phone(thisObject, rstring);
    return;
}

